/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorType;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.client.render.conveyor.SplitConveyorRender;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class SplitConveyor
extends ConveyorBase {
    public static final ResourceLocation NAME = ImmersiveEngineering.rl("splitter");
    public static final ResourceLocation texture_on = ImmersiveEngineering.rl("block/conveyor/split");
    public static final ResourceLocation texture_off = ImmersiveEngineering.rl("block/conveyor/split_off");
    public static final IConveyorType<SplitConveyor> TYPE = new BasicConveyorType<SplitConveyor>(NAME, false, true, SplitConveyor::new, () -> new SplitConveyorRender(texture_on, texture_off));
    boolean nextOutputLeft = true;

    public SplitConveyor(BlockEntity tile) {
        super(tile);
    }

    public IConveyorType<SplitConveyor> getType() {
        return TYPE;
    }

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return ConveyorHandler.ConveyorDirection.HORIZONTAL;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().m_58899_().hashCode());
        if (entity.getPersistentData().m_128425_(nbtKey, 3)) {
            Direction redirect = Direction.values()[entity.getPersistentData().m_128451_(nbtKey)];
            BlockPos nextPos = this.getBlockEntity().m_58899_().m_142300_(redirect);
            double distNext = Math.abs((double)(redirect.m_122434_() == Direction.Axis.Z ? nextPos.m_123343_() : nextPos.m_123341_()) + 0.5 - (redirect.m_122434_() == Direction.Axis.Z ? entity.m_20189_() : entity.m_20185_()));
            BlockEntity inventoryTile = this.getBlockEntity().m_58904_().m_7702_(nextPos);
            if (distNext < 0.7 && inventoryTile != null && !(inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                ItemUtils.tryInsertEntity(this.getBlockEntity().m_58904_(), this.getBlockEntity().m_58899_().m_142300_(redirect), redirect.m_122424_(), entity);
            }
        }
    }

    @Override
    public void onEntityCollision(@Nonnull Entity entity) {
        BlockPos nextPos;
        String nbtKey;
        if (!this.isActive()) {
            return;
        }
        Direction redirect = null;
        if (entity.m_6084_()) {
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().m_58899_().hashCode());
            if (entity.getPersistentData().m_128425_(nbtKey, 3)) {
                redirect = Direction.values()[entity.getPersistentData().m_128451_(nbtKey)];
            } else {
                redirect = this.getOutputFace();
                entity.getPersistentData().m_128405_(nbtKey, redirect.ordinal());
                nextPos = this.getBlockEntity().m_58899_().m_142300_(this.getOutputFace().m_122424_());
                if (this.getBlockEntity().m_58904_().m_46805_(nextPos)) {
                    BlockEntity nextTile = this.getBlockEntity().m_58904_().m_7702_(nextPos);
                    if (!(nextTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                        this.nextOutputLeft = !this.nextOutputLeft;
                    } else if (((ConveyorHandler.IConveyorBlockEntity)nextTile).getFacing() != this.getOutputFace()) {
                        this.nextOutputLeft = !this.nextOutputLeft;
                    }
                }
            }
        }
        super.onEntityCollision(entity);
        if (redirect != null) {
            boolean contact;
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().m_58899_().hashCode());
            nextPos = this.getBlockEntity().m_58899_().m_142300_(redirect);
            double distNext = Math.abs((double)(redirect.m_122434_() == Direction.Axis.Z ? nextPos.m_123343_() : nextPos.m_123341_()) + 0.5 - (redirect.m_122434_() == Direction.Axis.Z ? entity.m_20189_() : entity.m_20185_()));
            double treshold = 0.4;
            boolean bl = contact = distNext < treshold;
            if (contact) {
                entity.getPersistentData().m_128473_(nbtKey);
            }
        }
    }

    @Override
    public Direction[] sigTransportDirections() {
        return new Direction[]{this.getFacing().m_122427_(), this.getFacing().m_122428_()};
    }

    @Override
    public Vec3 getDirection(Entity entity, boolean outputBlocked) {
        Vec3 vec = super.getDirection(entity, outputBlocked);
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().m_58899_().hashCode());
        if (!entity.getPersistentData().m_128425_(nbtKey, 3)) {
            return vec;
        }
        Direction redirect = Direction.m_122376_((int)entity.getPersistentData().m_128451_(nbtKey));
        BlockPos wallPos = this.getBlockEntity().m_58899_().m_142300_(this.getFacing());
        double distNext = Math.abs((double)(this.getFacing().m_122434_() == Direction.Axis.Z ? wallPos.m_123343_() : wallPos.m_123341_()) + 0.5 - (this.getFacing().m_122434_() == Direction.Axis.Z ? entity.m_20189_() : entity.m_20185_()));
        if (distNext < 1.33) {
            double sideMove = Math.pow(1.0 + distNext, 0.1) * 0.2;
            if (distNext < 0.8) {
                vec = new Vec3(this.getFacing().m_122434_() == Direction.Axis.X ? 0.0 : vec.f_82479_, vec.f_82480_, this.getFacing().m_122434_() == Direction.Axis.Z ? 0.0 : vec.f_82481_);
            }
            vec = vec.m_82520_((double)redirect.m_122429_() * sideMove, 0.0, (double)redirect.m_122431_() * sideMove);
        }
        return vec;
    }

    @Override
    public CompoundTag writeConveyorNBT() {
        CompoundTag nbt = super.writeConveyorNBT();
        nbt.m_128379_("nextLeft", this.nextOutputLeft);
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundTag nbt) {
        super.readConveyorNBT(nbt);
        this.nextOutputLeft = nbt.m_128471_("nextLeft");
    }

    @Override
    public List<BlockPos> getNextConveyorCandidates() {
        BlockPos baseOutput = this.getBlockEntity().m_58899_().m_142300_(this.getOutputFace());
        return ImmutableList.of((Object)baseOutput, (Object)baseOutput.m_7495_());
    }

    @Override
    public boolean isOutputBlocked() {
        Direction outputFace = this.getOutputFace();
        BlockPos here = this.getBlockEntity().m_58899_();
        for (BlockPos outputPos : new BlockPos[]{here.m_5484_(outputFace, 1), here.m_5484_(outputFace, -1)}) {
            BlockEntity tile = SafeChunkUtils.getSafeBE((LevelAccessor)this.getBlockEntity().m_58904_(), outputPos);
            if (!(tile instanceof ConveyorHandler.IConveyorBlockEntity) || !((ConveyorHandler.IConveyorBlockEntity)tile).getConveyorInstance().isBlocked()) continue;
            return true;
        }
        return false;
    }

    private Direction getOutputFace() {
        if (this.nextOutputLeft) {
            return this.getFacing().m_122428_();
        }
        return this.getFacing().m_122427_();
    }
}

